#ifndef __master_h
#define __master_h

#define IVTENTRYCT 107   // hardcoded maximum for the STM32F42xxx

#define SECTION_FLASH_ISRVECTORS_BL __attribute__ ((section(".isr_vector_bl")))
#define SECTION_FLASH_MCB_BL        __attribute__ ((section(".mcb_bl")))
#define SECTION_FLASH_ISRVECTORS_FW __attribute__ ((section(".isr_vector_fw")))
#define SECTION_FLASH_MCB_FW        __attribute__ ((section(".mcb_fw")))

#define SECTION_RAM_STACK __attribute__ ((section(".stack")))

#define MCB_VERSION_LENGTH 4  // arbitrary but not modifiable!

typedef void (*IVTVector)(void);

typedef void (*MITVector)(void);  // for readability reasons
typedef void (*MITVector1ul)(unsigned long p_Arg);  // for readability reasons


enum
{
    MIT_BL_VECTOR_DISPATCHISRTOBL = 0,
    MIT_BL_TOGGLELED,
};

typedef struct MIT
{
    unsigned long m_EntryCt;
    MITVector m_Vectors[MIT_VECTOR_COUNT];
} MIT, *PMIT;

typedef struct IMAGEHEADER
{
    unsigned long m_ImageLen;
    unsigned long m_BaseAddress;
    unsigned char m_Version[MCB_VERSION_LENGTH];
} IMAGEHEADER,*PIMAGEHEADER;

#define MCB_SIGNATURE_BL 0x54329867
#define MCB_SIGNATURE_FW 0x54329876

typedef struct MCB
{
    unsigned long m_Sig;  // magic number
    struct IMAGEHEADER m_Header;
    struct MIT m_Mit;
} MCB, *PMCB;

extern const MCB g_bl_mcb;
extern const MCB g_fw_mcb;

extern unsigned long _sidata;
extern unsigned long _eidata;
extern unsigned long _sdata;
extern unsigned long _edata;
extern unsigned long _sbss;
extern unsigned long _ebss;
extern unsigned long _estack;
extern unsigned long _flashstart_bl;

#endif